
//Lognormal Distribution
//OS:Windows 10
//Scilab 5.5.2

clear all;
clc;
close;

X = [18.8, 27.9, 21.0, 6.1, 37.4, 5.0, 22.9, 1.0, 3.1, 8.3] // rate

X1=[]
X2=[]

n=length(X)

for i=1:n
    X1($+1)=log(X(i))
    X2($+1)=X1(i)**2
end
Xbar = sum(X1)/n
S2 = (sum(X2) - (n*(Xbar)**2))/(n-1)

//Result
mprintf("   ----------------------------------------\n")
mprintf("     Rates(X)                 lognormal(X1)")
mprintf("\n    ----------------------------------------\n")
for i=1:10
    mprintf("\n     %.1f\t\t\t%.1f",X(i),X1(i))
end
mprintf("\n    ----------------------------------------\n")
mprintf("\n N=%d",n)
mprintf("\n mu = Xbar = Sum(lognormal)/N = %f",Xbar)
mprintf("\nS^2 = (Sum(X1i^2) - (N*(Xbar)^2))/(N-1) = %f",S2)
